
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "../../ChessV.h"
#include "../../Resource.h"
#include "ChessGame.h"
#include "../../GameParameters.h"
#include "../../rand.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


LRESULT CALLBACK Chess_SelectDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	int dlgRtn = 0;
	bool whiteAlmostChess = false;
	bool blackAlmostChess = false;

	switch( Msg )
	{
	  case WM_INITDIALOG:
		if( !strcmp( gameSelection, "Fischer Random Chess" ) )
			::SendDlgItemMessage( hWndDlg, IDC_FISCHER_RANDOM_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Chess 480" ) )
			::SendDlgItemMessage( hWndDlg, IDC_CHESS480_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Chess 256" ) )
			::SendDlgItemMessage( hWndDlg, IDC_CHESS256_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Berolina Chess" ) )
			::SendDlgItemMessage( hWndDlg, IDC_BEROLINA_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Switching Chess" ) )
			::SendDlgItemMessage( hWndDlg, IDC_SWITCHING_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Polymorph Chess" ) )
			::SendDlgItemMessage( hWndDlg, IDC_POLYMORPH_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Cylindrical Chess" ) )
			::SendDlgItemMessage( hWndDlg, IDC_CYLINDRICAL_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Chess with Different Armies" ) )
			::SendDlgItemMessage( hWndDlg, IDC_CWDA_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
//		else if( !strcmp( gameSelection, "Chess with Augmented Knights" ) )
//			::SendDlgItemMessage( hWndDlg, IDC_CWAK_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Spartan Chess" ) ) 
			::SendDlgItemMessage( hWndDlg, IDC_SPARTAN_CHESS_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Almost Chess" ) )
			::SendDlgItemMessage( hWndDlg, IDC_ALMOST_CHESS_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Extinction Chess" ) )
			::SendDlgItemMessage( hWndDlg, IDC_EXTINCTION_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Kinglet" ) )
			::SendDlgItemMessage( hWndDlg, IDC_KINGLET_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Knightmate" ) )
			::SendDlgItemMessage( hWndDlg, IDC_KNIGHTMATE_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Three Checks Chess" ) )
			::SendDlgItemMessage( hWndDlg, IDC_THREE_CHECKS_RADIO2, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else if( !strcmp( gameSelection, "Ultima" ) )
			::SendDlgItemMessage( hWndDlg, IDC_ULTIMA_RADIO1, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		else
			::SendDlgItemMessage( hWndDlg, IDC_CHESS_RADIO, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		return TRUE;
		
	  case WM_COMMAND:
		switch(wParam)
		{
		  case IDOK:
			if( ::SendDlgItemMessage( hWndDlg, IDC_CHESS_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Orthodox Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_FISCHER_RANDOM_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Fischer Random Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CHESS480_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Chess 480" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CHESS256_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Chess256" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_BEROLINA_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Berolina Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_SWITCHING_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Switching Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_POLYMORPH_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Polymorph Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CYLINDRICAL_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Cylindrical Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_CWDA_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Chess with Different Armies" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_SPARTAN_CHESS_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Spartan Chess" );
//			else if( ::SendDlgItemMessage( hWndDlg, IDC_CWAK_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
//				strcpy( gameSelection, "Chess with Augmented Knights" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_ALMOST_CHESS_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Almost Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_EXTINCTION_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Extinction Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_KINGLET_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Kinglet" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_KNIGHTMATE_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Knightmate" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_THREE_CHECKS_RADIO2, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Three Checks Chess" );
			else if( ::SendDlgItemMessage( hWndDlg, IDC_ULTIMA_RADIO1, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
				strcpy( gameSelection, "Ultima" );
			else
				ASSERT(FALSE);

			if( ::SendDlgItemMessage( hWndDlg, IDC_CWDA_RADIO, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED )
			{
				StoreParameter( "white-army", "Fabulous FIDEs" );
				StoreParameter( "black-army", "Fabulous FIDEs" );
			}
			::EndDialog( hWndDlg, dlgRtn );
			return TRUE;
		}
		break;
	}

	return FALSE;
}
