
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "CylindricalChessGame.h"
#include "../../Resource.h"
#include "../../ChessV.h"
#include "../../Boards/CylindricalBoard.h"
#include "../../GameParameters.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


void StartCylindricalChessGame()
{
	if( !justLoaded )
		int rtn = (int) ::DialogBox( theInstance, MAKEINTRESOURCE(IDD_GENERIC_GAME_DIALOG), NULL, 
			reinterpret_cast<DLGPROC>(Generic_SelectDlgProc) );

	theBoard = new CylindricalBoard( 8, 8 );
	char *player0Name = "White";
	char *player1Name = "Black";
	LookupStringParameter( "player1", player0Name );
	LookupStringParameter( "player2", player1Name );
	CreatePlayers( player0Name, player1Name, whiteComp, blackComp );

	strcpy( gameSelection, "Cylindrical Chess" );
}

Game *CreateCylindricalChessGame( Board &brd, Player &plr0, Player &plr1 )
{
	return new CylindricalChessGame( brd, plr0, plr1 );
}

CylindricalChessGame::CylindricalChessGame( Board &board, Player &whitePlayer, Player &blackPlayer ):
	ChessGame(board, whitePlayer, blackPlayer)
{
	// *** change settings from ChessGame that are not correct *** //


	//	we need to adjust the value of the pieces; the knights are a little 
	//	more powerful than they are normally.  the bishop is MUCH more
	//	viscious, as is the queen
	OrthodoxKnight::orthodoxKnight.SetBaseValue( 3400 );
	OrthodoxBishop::orthodoxBishop.SetBaseValue( 4400 );
	OrthodoxBishop::orthodoxBishop.SetPerCaptureValueBonus( 50 );
	OrthodoxBishop::orthodoxBishop.SetPerCaptureBonusThreshold( 10 );
	OrthodoxQueen::orthodoxQueen.SetBaseValue( 10150 );
}

void CylindricalChessGame::ChangeRulesByVariant
	( char *gameName,
	  char *&array,
	  char *&book )
{
	// *** CYLINDRICAL CHESS *** //
	if( !strcmp( gameName, "Cylindrical Chess" ) )
	{
		//	place pieces
		array = "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR";
		//	set name of opening book
		book = "openings\\CylindricalChess.txt";
	}
}