
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2016 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "../../ChessV.h"
#include "../../GameParameters.h"
#include "EnepGame.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


Game *CreateEnepGame( Board &brd, Player &plr0, Player &plr1 )
{
	return new EnepGame( brd, plr0, plr1 );
}

EnepGame::EnepGame( Board &board, Player &whitePlayer, Player &blackPlayer ):
	ChessGame(board, whitePlayer, blackPlayer)
{
	// *** OUTPOSTS *** //

	//	we use the user variable 'gameInt1' in the PieceType class
	//	to store the 'outpost factor' for a given piece.  this value will
	//	be multiplied by the square-values stored in the 'outpost' array.
	OrthodoxKnight::orthodoxKnight.gameInt1 = 8;
	EnepKnight::enepKnight.gameInt1 = 8;
}

void EnepGame::AddPlayerPieceTypes( char *gameName )
{
	//	add the piece types that each player may have
	board.AddPlayerPieceTypeBothPlayers( OrthodoxRook::orthodoxRook );
	board.AddPlayerPieceTypeBothPlayers( OrthodoxBishop::orthodoxBishop );
	board.AddPlayerPieceTypeBothPlayers( OrthodoxKnight::orthodoxKnight );
	board.AddPlayerPieceTypeBothPlayers( OrthodoxQueen::orthodoxQueen );
	board.AddPlayerPieceTypeBothPlayers( OrthodoxKing::orthodoxKing );
	board.AddPlayerPieceTypeBothPlayers( OrthodoxPawn::orthodoxPawn );
	board.AddPlayerPieceTypeBothPlayers( EnepKnight::enepKnight );
	//	initialize piece type references
	castlingPieceTypes[0] = &OrthodoxRook::orthodoxRook;
	castlingPieceTypes[1] = &OrthodoxRook::orthodoxRook;
	minorPieceTypes[0][0] = &OrthodoxKnight::orthodoxKnight;
	minorPieceTypes[1][0] = &OrthodoxKnight::orthodoxKnight;
	minorPieceTypes[0][1] = &OrthodoxBishop::orthodoxBishop;
	minorPieceTypes[1][1] = &OrthodoxBishop::orthodoxBishop;
	minorPieceTypes[0][2] = &EnepKnight::enepKnight;
	minorPieceTypes[1][2] = &EnepKnight::enepKnight;
	minorPieceTypes[0][3] = &NullPieceType64::nullPieceType64;
	minorPieceTypes[1][3] = &NullPieceType64::nullPieceType64;
	colorboundPieceTypes[0][0] = &OrthodoxBishop::orthodoxBishop;
	colorboundPieceTypes[1][0] = &OrthodoxBishop::orthodoxBishop;
	colorboundPieceTypes[0][1] = &NullPieceType64::nullPieceType64;
	colorboundPieceTypes[1][1] = &NullPieceType64::nullPieceType64;
	queenPieceTypes[0] = &OrthodoxQueen::orthodoxQueen;
	queenPieceTypes[1] = &OrthodoxQueen::orthodoxQueen;
	pawnPieceTypes[0] = &OrthodoxPawn::orthodoxPawn;
	pawnPieceTypes[1] = &OrthodoxPawn::orthodoxPawn;
	castlingPiecesSlideNorth[0] = true;
	castlingPiecesSlideNorth[1] = true;
}

static char filename[] = "openings\\Enep.txt";

void EnepGame::ChangeRulesByVariant
	( char *gameName,
	  char *&array,
	  char *&book )
{
	// *** ENEP *** //
	if( !strcmp( gameName, "Enep" ) )
	{
		//	place pieces
		array = "rabqkbar/pppppppp/8/8/8/3P4/PPPPPPPP/RNBQKBNR";
		//	set name of opening book
		book = filename;
	}
}

void EnepGame::Initialize()
{

	//	let the base class Initialize() do its thing
	ChessGame::Initialize();
}
