
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "../../ChessV.h"
#include "../../Resource.h"
#include "../../GameParameters.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


static HWND hSubDialog;


LRESULT CALLBACK FRC_SelectDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	char numberText[20];

	switch( Msg )
	{
	  case WM_INITDIALOG:
		{
			//	create the computer settings sub-dialog
			HRSRC hrsrc = FindResource( NULL, MAKEINTRESOURCE(IDD_COMPUTER_SETTINGS_EMBEDDED_DIALOG), RT_DIALOG ); 
			HGLOBAL hglb = LoadResource( theInstance, hrsrc ); 
			hSubDialog = ::CreateDialogIndirect( theInstance, (DLGTEMPLATE *) LockResource( hglb ), 
				hWndDlg, reinterpret_cast<DLGPROC>(Generic_SelectSubDlgProc) ); 
			HWND hStaticPlacementItem = ::GetDlgItem( hWndDlg, IDC_COMPUTER_SETTINGS_STATIC );
			RECT childRect;
			::GetWindowRect( hStaticPlacementItem, &childRect );
			POINT point;
			point.x = 0;
			point.y = 0;
			::ClientToScreen( hWndDlg, &point );
			::MoveWindow( hSubDialog, childRect.left - point.x, childRect.top - point.y, childRect.right - childRect.left, 
				childRect.bottom - childRect.top, TRUE );
			::ShowWindow( hSubDialog, SW_SHOWNORMAL );
			//	generate random number for starting array
			time_t seconds;
			time( &seconds );
			srand( (unsigned int) seconds );
			rand();
			rand();
			double r = ((double) rand() / ((double) (RAND_MAX) + (double) 1));
			double r2 = (r * 960);
			int positionNumber = (int) r2;
			itoa( positionNumber, numberText, 10 );
			::SetWindowText( ::GetDlgItem( hWndDlg, IDC_POSITION_EDIT ), numberText );
			return TRUE;
		}

	  case WM_COMMAND:
		switch(wParam)
		{
		  case IDOK:
		  {
			::GetWindowText( ::GetDlgItem( hWndDlg, IDC_POSITION_EDIT ), numberText, 20 );
			int positionNumber = atoi( numberText );
			if( positionNumber < 0 || positionNumber > 959 )
			{
				::MessageBox( hWndDlg, "The position number must be between 0 and 959",
					"Error", MB_OK | MB_ICONHAND );
				return FALSE;
			}
			StoreParameter( "position-number", positionNumber );
			::EndDialog( hWndDlg, IDOK );
			return TRUE;
		  }
		}
		break;
	}

	return FALSE;
}

