
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "KingletGame.h"
#include "../../Resource.h"
#include "../../ChessV.h"
#include "../../GameParameters.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


Game *CreateKingletGame( Board &brd, Player &plr0, Player &plr1 )
{
	return new KingletGame( brd, plr0, plr1 );
}

KingletGame::KingletGame( Board &board, Player &whitePlayer, Player &blackPlayer ):
	ChessGame(board, whitePlayer, blackPlayer)
{
	// *** change default settings from ChessGame that *** //
	// ***     are not appropriate for this game       *** //

	//	there is no Check or Checkmate
	goalIsCheckmate = false;

	//	the king is not royal, and we'll give it a combat value of 4000 
	OrthodoxKing::orthodoxKing.SetRoyal( false );
	OrthodoxKing::orthodoxKing.SetBaseValue( 4000 );

	//	since the king is not royal, change the piece-square-tables to 
	//	encourage it to move to the center rather than hide in the corner
	OrthodoxKing::orthodoxKing.SetSquareBonuses( 0, endgameKingSquareBonuses );
	OrthodoxKing::orthodoxKing.SetSquareBonuses( 1, endgameKingSquareBonuses );

	//	pawns always promote to kings
	OrthodoxPawn::orthodoxPawn.SetPromotionType( PromoteToSpecificType );
	OrthodoxPawn::orthodoxPawn.SetTypeToPromoteTo( OrthodoxKing::orthodoxKing );

	//	since the pawn is royal, we want the material value of the pawn 
	//	to get larger and larger as more and more pieces are captured  
	OrthodoxPawn::orthodoxPawn.SetPerCaptureBonusThreshold( 0 );
	OrthodoxPawn::orthodoxPawn.SetPerCaptureValueBonus( 75 );
}

void KingletGame::ChangeRulesByVariant
	( char *gameName,
	  char *&array,
	  char *&book )
{
	// *** KINGLET *** //
	if( !strcmp( gameName, "Kinglet" ) )
	{
		//	use the same handling as Orthodox Chess, except for
		//	the name of the opening book, and the pawn promotion 
		//	rule, which we will change after
		ChessGame::ChangeRulesByVariant( "Orthodox Chess", array, book );
		//	change pawn promotion rule
		OrthodoxPawn::orthodoxPawn.SetPromotionType( PromoteToSpecificType );
		OrthodoxPawn::orthodoxPawn.SetTypeToPromoteTo( OrthodoxKing::orthodoxKing );
		//	set name of opening book
		book = "openings\\Kinglet.txt";
	}
}

Piece *KingletGame::AddPiece
	( PieceType &pieceType,
	  int nPlayer,
	  int nRank,
	  int nFile )
{
	Piece *newPiece = ChessGame::AddPiece( pieceType, nPlayer, nRank, nFile );

	//	since King's aren't royal, we need to look for them here and set the 
	//	Board class's King property so that they can be used for castling
	if( &pieceType == &OrthodoxKing::orthodoxKing )
		board.SetKing( nPlayer, newPiece );

	return newPiece;
}

bool KingletGame::TestForWinLossDraw
	( int &eval )
{
	if( OrthodoxPawn::orthodoxPawn.GetPieces( 0 ) == 0 )
	{
		// *** player 0 has no pawns, player 1 wins *** //
		if( board.GetCurrentPlayerNumber() == 0 )
			eval = -INFINITY;
		else
			eval = INFINITY;
		return true;
	}
	if( OrthodoxPawn::orthodoxPawn.GetPieces( 1 ) == 0 )
	{
		// *** player 1 has no pawns, player 0 wins *** //
		if( board.GetCurrentPlayerNumber() == 0 )
			eval = INFINITY;
		else
			eval = -INFINITY;
		return true;
	}
	return false;
}
