
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2007 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__LEMURIAN_SHATRANJ_GAME_H
#define FILE__LEMURIAN_SHATRANJ_GAME_H


#include "../../Board.h"
#include "../../Player.h"
#include "../../PieceType.h"
#include "../../Game.h"
#include "ChessGame.h"
#include "ChessPieceTypes.h"


//	*************************************
//	**                                 **
//	**      LemurianShatranjGame       **
//	**                                 **
//	*************************************

class LemurianShatranjGame:
	public ChessGame
{
  protected:
	// *** PROTECTED DATA MEMBERS *** //

	//	helper bitboards for move generation
	BitBoard64 bb64wazirMoves[64];
	BitBoard64 bb64ferzMoves[64];
	BitBoard64 bb64dababbahMoves[64];
	BitBoard64 bb64alfilMoves[64];
	BitBoard64 bb64wazirDababbahMoves[64];
	BitBoard64 bb64ferzAlfilMoves[64];
	BitBoard64 bb64ferzWazirMoves[64];
	BitBoard64 bb64indirectBentHeroAttacks[64];
	BitBoard64 bb64indirectBentHeroAttackMustBeFreeSquares[64][64];
	BitBoard64 bb64indirectBentShamanAttacks[64];
	BitBoard64 bb64indirectBentShamanAttackMustBeFreeSquares[64][64];
	BitBoard64 bb64indirectSlidingGeneralAttacks[64];
	BitBoard64 bb64indirectSlidingGeneralAttackMustBeFreeSquares[64][64];

	// *** HELPER FUNCTIONS *** //
	void InitializeMovementBitboards();
	void GenerateMovesForPieceByBitboard( int startSquare, BitBoard64 moves, MovementList &list );
	void GenerateBentHeroMoves( int currentPlayer, MovementList &list, bool quiescentSearch );
	void GenerateBentShamanMoves( int currentPlayer, MovementList &list, bool quiescentSearch );
	void GenerateSlidingGeneralMoves( int currentPlayer, MovementList &list, bool quiescentSearch );


  public:
	// *** INITIALIZATION *** //
	LemurianShatranjGame( Board &board, Player &whitePlayer, Player &blackPlayer );

	virtual void AddPlayerPieceTypes( char *gameName );

	virtual void ChangeRulesByVariant( char *gameName, char *&array, char *&book );

	virtual void InitializationComplete( char *gameName );


	// *** OVERRIDES *** //
	virtual bool MoveBeingMade
		( MoveInfo &moveInfo,
		  GameRec &gameRecord );

	virtual int EnumeratePromotions
		( Piece *piece, 
		  int fromSquare,
		  int toSquare,
		  PieceType **promotions,
		  bool quiescentSearch );

	virtual int EnumeratePromotions
		( Piece *piece,
		  int fromSquare,
		  int toSquare,
		  Piece **promotions,
		  bool quiescentSearch );

	virtual void AddSpecialMoves
		( int currentPlayer, 
		  MovementList &stack,
		  GameRec &gameRecord,
		  bool quiescentSearch );

	virtual bool IsSquareAttacked
		( int squareNumber, 
		  int playerNumber );
};


#endif
