
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__POLYMORPH_CHESS_TYPES_H
#define FILE__POLYMORPH_CHESS_TYPES_H


class PolymorphAsKnight:
	public PieceType64
{
  public:
	//	construction
	PolymorphAsKnight():
		PieceType64("Polymorph As Knight", "Knight", "N", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			//	initialize all properties to defaults
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnight.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
			SetSquareBonuses( 0, knightSquareBonuses );
			SetSquareBonuses( 1, knightSquareBonuses );
			SetSquareBonuses( 2, knightSquareBonuses );
		}
		baseValue = 3200;
		optimization = SimpleSingleStep;
	}

	static PolymorphAsKnight polymorphAsKnight;
};


class PolymorphAsBishop:
	public PieceType64
{
  public:
	//	construction
	PolymorphAsBishop():
		PieceType64("Polymorph As Bishop", "Bishop", "B", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BBishop.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		}
		baseValue = 3150;
		perCaptureValueBonus = 14;
		perCaptureBonusThreshold = 10;
	}

	static PolymorphAsBishop polymorphAsBishop;
};


class PolymorphAsKnishop:
	public PieceType64
{
  public:
	//	construction
	PolymorphAsKnishop():
		PieceType64("Polymorph As Knishop", "Knishop", "_NB", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WFKnightBBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BFKnightBBishop.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 0 ) );
			AddMovementCapability( MovementCapability(  1, -1, 0 ) );
		}

		baseValue = 3200;
		perCaptureValueBonus = 14;
		perCaptureBonusThreshold = 4;
		SetSquareBonuses( 0, knightSquareBonuses );
		SetSquareBonuses( 1, knightSquareBonuses );
		SetSquareBonuses( 2, knightSquareBonuses );
	}

	static PolymorphAsKnishop polymorphAsKnishop;
};


class PolymorphAsBishight:
	public PieceType64
{
  public:
	//	construction
	PolymorphAsBishight():
		PieceType64("Polymorph As Bishight", "Bishight", "_BN", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WFBishopBKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BFBishopBKnight.bmp";
			AddMovementCapability( MovementCapability( -1,  1, 0 ) );
			AddMovementCapability( MovementCapability(  1,  1, 0 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 3160;
		perCaptureValueBonus = 14;
		perCaptureBonusThreshold = 7;
		SetSquareBonuses( 0, bishopSquareBonuses );
		SetSquareBonuses( 1, bishopSquareBonuses );
		SetSquareBonuses( 2, bishopSquareBonuses );
	}

	static PolymorphAsBishight polymorphAsBishight;
};


#endif
