
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "../../ChessV.h"
#include "../../PieceType.h"
#include "../../Piece.h"
#include "../../Direction.h"
#include "../../Rand.h"
#include "../../GameParameters.h"
#include "ShatranjKamil64Game.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


Game *CreateShatranjKamil64Game( Board &brd, Player &plr0, Player &plr1 )
{
	return new ShatranjKamil64Game( brd, plr0, plr1 );
}


ShatranjKamil64Game::ShatranjKamil64Game( Board &board, Player &whitePlayer, Player &blackPlayer ):
	ChessGame(board, whitePlayer, blackPlayer)
{
}

void ShatranjKamil64Game::AddPlayerPieceTypes( char *gameName )
{
	//	augment the Elephant
	Elephant::elephant.AddMovementCapability( MovementCapability(  0,  2, 1, MoveOnly ) );
	Elephant::elephant.AddMovementCapability( MovementCapability(  0, -2, 1, MoveOnly ) );
	Elephant::elephant.AddMovementCapability( MovementCapability(  2,  0, 1, MoveOnly ) );
	Elephant::elephant.AddMovementCapability( MovementCapability( -2,  0, 1, MoveOnly ) );
	Elephant::elephant.SetMovementOptimization( NoOptimization );
	Elephant::elephant.SetBaseValue( 1850 );
	//	add the piece types that each player may have
	board.AddPlayerPieceTypeBothPlayers( OrthodoxRook::orthodoxRook );
	board.AddPlayerPieceTypeBothPlayers( Elephant::elephant );
	board.AddPlayerPieceTypeBothPlayers( OrthodoxKnight::orthodoxKnight );
	board.AddPlayerPieceTypeBothPlayers( Ferz::ferz );
	board.AddPlayerPieceTypeBothPlayers( SilverGeneral::silverGeneral );
	board.AddPlayerPieceTypeBothPlayers( OrthodoxKing::orthodoxKing );
	board.AddPlayerPieceTypeBothPlayers( LamePawn::lamePawn );
	//	add piece type references to the following arrays, 
	//	minorPieceTypes, etc., used for giving bonuses and 
	//	penalties in positional evaluation
	castlingPieceTypes[0] = &OrthodoxRook::orthodoxRook;
	castlingPieceTypes[1] = &OrthodoxRook::orthodoxRook;
	minorPieceTypes[0][0] = &OrthodoxKnight::orthodoxKnight;
	minorPieceTypes[1][0] = &OrthodoxKnight::orthodoxKnight;
	minorPieceTypes[0][1] = &Elephant::elephant;
	minorPieceTypes[1][1] = &Elephant::elephant;
	minorPieceTypes[0][2] = &Ferz::ferz;
	minorPieceTypes[1][2] = &Ferz::ferz;
	minorPieceTypes[0][3] = &SilverGeneral::silverGeneral;
	minorPieceTypes[1][3] = &SilverGeneral::silverGeneral;
	colorboundPieceTypes[0][0] = &Elephant::elephant;
	colorboundPieceTypes[1][0] = &Elephant::elephant;
	colorboundPieceTypes[0][1] = &Ferz::ferz;
	colorboundPieceTypes[1][1] = &Ferz::ferz;
	queenPieceTypes[0] = &NullPieceType64::nullPieceType64;
	queenPieceTypes[1] = &NullPieceType64::nullPieceType64;
	pawnPieceTypes[0] = &LamePawn::lamePawn;
	pawnPieceTypes[1] = &LamePawn::lamePawn;
	castlingPiecesSlideNorth[0] = true;
	castlingPiecesSlideNorth[1] = true;
}

void ShatranjKamil64Game::ChangeRulesByVariant
	( char *gameName,
	  char *&array,
	  char *&book )
{
	// *** SHATRANJ KAMIL 64 *** //
	if( !strcmp( gameName, "Shatranj Kamil (64)" ) )
	{
		//	no castling in Shatranj
		castlingType = CASTLING_TYPE_NONE;
		//	no en-Passant
		enPassant = false;
		//	use 'bare king' rule
		bareKingRule = true;
		//	stalemate is a win
		stalemateResult = INFINITY;
		//	change pawn promotion
		LamePawn::lamePawn.SetPromotionType( PromoteToSpecificType );
		LamePawn::lamePawn.SetTypeToPromoteTo( SilverGeneral::silverGeneral );
		//	Knights and Rooks are move valuble than usual
		OrthodoxKnight::orthodoxKnight.SetBaseValue( 4000 );
		OrthodoxRook::orthodoxRook.SetBaseValue( 5500 );
		//	place pieces
		array = "rnseksnr/pp1ge1pp/2pppp2/8/8/2PPPP2/PP1GE1PP/RNSEKSNR";
		//	set name of opening book
		book = "openings\\ShatranjKamil64.txt";
	}
}

void ShatranjKamil64Game::DefaultSettings()
{
	squareColor1 = RGB(255, 255, 204);
	squareColor2 = RGB(93, 126, 126);
	pieceColor1 = RGB(255, 255, 255);
	pieceColor2 = RGB(89, 132, 189);
	borderColor = RGB(128, 70, 70);
	boardDisplayType = BOARD_IS_CHECKERED;
	selectedPieceSet = PIECE_SET_STANDARD;
}
