
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2011 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__SPARTAN_CHESS_GAME_H
#define FILE__SPARTAN_CHESS_GAME_H


#include "../../Board.h"
#include "../../Player.h"
#include "../../PieceType.h"
#include "ChessPieceTypes.h"
#include "ChessGame.h"	


//	******************************
//	**                          **
//	**     SpartanChessGame     **
//	**                          **
//	******************************


class SpartanChessGame:
	public ChessGame
{
  public:
	// *** INITIALIZATION *** //
	SpartanChessGame( Board &board, Player &whitePlayer, Player &blackPlayer );

	virtual void AddPlayerPieceTypes( char *gameName );


	// *** OVERRIDES *** //
	virtual void ChangeRulesByVariant
		( char *gameName,
		  char *&array,
		  char *&book );

	virtual bool IsInCheck( Piece *king );

	virtual int EnumeratePromotions
		( Piece *piece, 
		  int fromSquare,
		  int toSquare,
		  PieceType **pieces,
		  bool quiescentSearch );

	virtual void AddSpecialMoves
		( int currentPlayer, 
		  MovementList &stack,
		  GameRec &gameRecord,
		  bool quiescentSearch );

	virtual word32 AdjustPrimaryHash
		( word32 primaryHash );

	virtual void GenerateMoves
		( int currentPlayer, 
		  MovementList &list );

	virtual void GenerateCaptures
		( int currentPlayer, 
		  MovementList &list );

	virtual bool IsSquareAttacked
		( int squareNumber, 
		  int playerNumber );

	virtual Phase &SpartanChessGame::AdjustEvaluation
		( int &eval,
		  PawnHash *pPawnHash );
}


#endif
