
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__SWITCHING_CHESS_GAME_H
#define FILE__SWITCHING_CHESS_GAME_H


#include "ChessGame.h"


class SwitchingChessGame:
	public ChessGame
{
  protected:
	int restriction;
	//	are we playing the restricted variant, in which we cannot
	//	switch while in Check? (restriction = 1)
	//	or where we cannot switch the King at all (restriction = 2)


  public:
	// *** INITIALIZATION *** //
	SwitchingChessGame( Board &board, Player &whitePlayer, Player &blackPlayer );

	virtual void ChangeRulesByVariant( char *gameName, char *&array, char *&book );

	virtual void ChangeRulesByVariableDefinition( char *gameName );


	// *** OVERRIDES *** //
	virtual void AddSpecialMoves
		( int currentPlayer, 
		  MovementList &stack,
		  GameRec &gameRecord, 
		  bool quiescentSearch );

	virtual void DescribeMove
		( MoveInfo &move,
		  char *queryDescription,
		  char *description,
		  char *notation );
};


#endif
