
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "ThreeChecksChessGame.h"
#include "../../Resource.h"
#include "../../ChessV.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


Game *CreateThreeChecksChessGame( Board &brd, Player &plr0, Player &plr1 )
{
	return new ThreeChecksChessGame( brd, plr0, plr1 );
}

ThreeChecksChessGame::ThreeChecksChessGame( Board &board, Player &whitePlayer, Player &blackPlayer ):
	ChessGame(board, whitePlayer, blackPlayer)
{
}

void ThreeChecksChessGame::ChangeRulesByVariant
	( char *gameName,
	  char *&array,
	  char *&book )
{
	// *** THREE CHECKS CHESS *** //
	if( !strcmp( gameName, "Three Checks Chess" ) )
	{
		//	place pieces
		array = "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR";
		//	set name of opening book
		book = "openings\\ThreeChecksChess.txt";
	}
}

bool ThreeChecksChessGame::MoveBeingMade
	( MoveInfo &moveInfo,
	  GameRec &gameRecord )
{
	if( board.IsOtherPlayerInCheck() )
	{
		if( board.GetCurrentPlayerNumber() == 1 )
		{
			gameRecord.gameInt2++;
		}
		else
		{
			gameRecord.gameInt2 += 256;
		}
	}

	return ChessGame::MoveBeingMade( moveInfo, gameRecord );
}

bool ThreeChecksChessGame::TestForWinLossDraw
	( int &eval )
{
	int gameInt2 = board.GetCurrentGameRecord().gameInt2;
	if( board.GetCurrentPlayerNumber() == 0 )
	{
		if( (gameInt2 & 3) == 3 )
		{
			eval = -INFINITY;
			return true;
		}
		else if( (gameInt2 & 768) == 768 )
		{
			eval = INFINITY;
			return true;
		}
	}
	else
	{
		if( (gameInt2 & 768) == 768 )
		{
			eval = -INFINITY;
			return true;
		}
		else if( (gameInt2 & 3) == 3 )
		{
			eval = INFINITY;
			return true;
		}
	}
	return false;
}

Phase &ThreeChecksChessGame::AdjustEvaluation
	( int &eval,
	  PawnHash *pPawnHash )
{
	int gameInt2 = board.GetCurrentGameRecord().gameInt2;
	if( (gameInt2 & 3) == 1 )
		eval -= 650;
	else if( (gameInt2 & 3) == 2 )
		eval -= 1750;
	if( (gameInt2 & 768) == 256 )
		eval += 650;
	else if( (gameInt2 & 768) == 512 )
		eval += 1750;
	return( ChessGame::AdjustEvaluation( eval, pPawnHash ) );
}

