
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "KingletGame.h"
#include "../../Resource.h"
#include "../../ChessV.h"


const char *StartGeneric8x8Game( int resID )
{
	int rtn = 0;
	if( resID >= 0 )
	{
		rtn = (int) ::DialogBox( theInstance, MAKEINTRESOURCE(IDD_GENERIC_8x8_DIALOG), NULL, 
			reinterpret_cast<DLGPROC>(Generic8x8_SelectDlgProc) );
	}
	theBoard = new Board( 8, 8 );
	pPlayer0 = new Player( "White", 0, whiteComp );
	pPlayer1 = new Player( "Black", 1, blackComp );
	if( resID == -1 )
		return NULL;
	return "Kinglet Chess";
}

Game *CreateGeneric8x8Game( Board &brd, Player &plr0, Player &plr1 )
{
	return new Generic8x8Game( brd, plr0, plr1 );
}

Generic8x8Game::Generic8x8Game( Board &board, Player &whitePlayer, Player &blackPlayer ):
	ChessGame(board, whitePlayer, blackPlayer)
{
	// *** change settings from ChessGame that are not correct *** //

	//	there is no Check or Checkmate
	goalIsCheckmate = false;

	//	the king is not royal, and we'll give it a combat value of 4000 
	OrthodoxKing::orthodoxKing.SetRoyal( false );
	OrthodoxKing::orthodoxKing.SetBaseValue( 4000 );
						   // \ 
	board.SetGame( this ); //  >- basic initialization
	InitializeBoard();     // / 

}

void Generic8x8Game::InitializeBoard()
{
	//	add white's pieces
	AddPiece( OrthodoxRook::orthodoxRook, 0, 0, 0 );
	AddPiece( OrthodoxRook::orthodoxRook, 0, 0, 7 );
	AddPiece( OrthodoxKnight::orthodoxKnight, 0, 0, 1 );
	AddPiece( OrthodoxKnight::orthodoxKnight, 0, 0, 6 );
	AddPiece( OrthodoxBishop::orthodoxBishop, 0, 0, 2 );
	AddPiece( OrthodoxBishop::orthodoxBishop, 0, 0, 5 );
	AddPiece( OrthodoxQueen::orthodoxQueen, 0, 0, 3 );

	//	add black's pieces
	AddPiece( OrthodoxRook::orthodoxRook, 1, 7, 0 );
	AddPiece( OrthodoxRook::orthodoxRook, 1, 7, 7 );
	AddPiece( OrthodoxKnight::orthodoxKnight, 1, 7, 1 );
	AddPiece( OrthodoxKnight::orthodoxKnight, 1, 7, 6 );
	AddPiece( OrthodoxBishop::orthodoxBishop, 1, 7, 2 );
	AddPiece( OrthodoxBishop::orthodoxBishop, 1, 7, 5 );
	AddPiece( OrthodoxQueen::orthodoxQueen, 1, 7, 3 );

	//	add the pawns
	for( int i = 0; i < 8; i++ )
	{
		//	for all variants supported by this class, we will have these
		//	8 pawns lined up on the 2nd and 7th rank
		AddPiece( OrthodoxPawn::orthodoxPawn, 0, 1, i );
		AddPiece( OrthodoxPawn::orthodoxPawn, 1, 6, i );
	}

	//	create the kings;  since they aren't royal, we need to set 
	//	the Board class's kings[] data, as they won't be detected 
	//	automatically
	board.SetKing( 0, AddPiece( OrthodoxKing::orthodoxKing, 0, 0, 4 ) );
	board.SetKing( 1, AddPiece( OrthodoxKing::orthodoxKing, 1, 7, 4 ) );

	if( useOpeningBook )
	{
		Book *pBook = new Book( &board );
		board.SetOpeningBook( pBook, "openings\\KingletChess.txt" );
	}

	board.Initialize();
}

bool Generic8x8Game::TestForWinLossDraw
	( int &eval )
{
	bool pawns[2] = { false, false };
	//	look through player 0's pieces
	for( int x = 0; x < board.GetNumberOfPawns( 0 ) && !pawns[0]; x++ )
	{
		Piece *piece = board.GetPawn( 0, x );
		if( !piece->IsCaptured() )
			pawns[0] = true;
	}
	//	look through player 1's pieces
	for( int x = 0; x < board.GetNumberOfPawns( 1 ) && !pawns[1]; x++ )
	{
		Piece *piece = board.GetPawn( 1, x );
		if( !piece->IsCaptured() )
			pawns[1] = true;
	}
	if( !pawns[0] )
	{
		//	white has no pawns
		if( board.GetCurrentPlayerNumber() == 0 )
			eval = -INFINITY;
		else
			eval = INFINITY;
		return true;
	}
	if( !pawns[1] )
	{
		//	black has no pawns
		if( board.GetCurrentPlayerNumber() == 1 )
			eval = -INFINITY;
		else
			eval = INFINITY;
		return true;
	}
	return false;
}
