
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "../ChessV.h"
#include "../Resource.h"
#include "../GameParameters.h"
#include "../boards/DecimalBoard.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


LRESULT CALLBACK Generic_SelectSubDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	bool book;
	switch( Msg )
	{
	  case WM_INITDIALOG:
		::SendDlgItemMessage( hWndDlg, IDC_THINK_TIME_EDIT, WM_SETTEXT, (WPARAM) 0, (LPARAM) "20" );
		if( LookupBoolParameter( "use-opening-book", book ) && !book )
			::EnableWindow( ::GetDlgItem( hWndDlg, IDC_OPENING_BOOK_CHECK ), false );
		else
			::SendDlgItemMessage( hWndDlg, IDC_OPENING_BOOK_CHECK, BM_SETCHECK, (WPARAM) BST_CHECKED, (LPARAM) 0 );
		return TRUE;
	}

	return FALSE;
}

LRESULT CALLBACK Generic_SelectDlgProc
	( HWND hWndDlg, 
	  UINT Msg, 
	  WPARAM wParam, 
	  LPARAM lParam )
{
	char buffer[20];
	static HWND hSubDialog;

	switch( Msg )
	{
	  case WM_INITDIALOG:
		{
			//	create the computer settings sub-dialog
			HRSRC hrsrc = FindResource( NULL, MAKEINTRESOURCE(IDD_COMPUTER_SETTINGS_EMBEDDED_DIALOG), RT_DIALOG ); 
			HGLOBAL hglb = LoadResource( theInstance, hrsrc ); 
			hSubDialog = ::CreateDialogIndirect( theInstance, (DLGTEMPLATE *) LockResource( hglb ), 
				hWndDlg, reinterpret_cast<DLGPROC>(Generic_SelectSubDlgProc) ); 
			HWND hStaticPlacementItem = ::GetDlgItem( hWndDlg, IDC_COMPUTER_SETTINGS_STATIC );
			RECT childRect;
			::GetWindowRect( hStaticPlacementItem, &childRect );
			POINT point;
			point.x = 0;
			point.y = 0;
			::ClientToScreen( hWndDlg, &point );
			::MoveWindow( hSubDialog, childRect.left - point.x, childRect.top - point.y, childRect.right - childRect.left, 
				childRect.bottom - childRect.top, TRUE );
			::ShowWindow( hSubDialog, SW_SHOWNORMAL );
			if( selectedVariant->dialogResourceID == IDD_GENERIC_GAME_DIALOG )
			{
				char buffer[80];
				if( strcmp( selectedVariant->inventor, "unknown" ) )
					sprintf( buffer, "by %s", selectedVariant->inventor );
				else
					sprintf( buffer, "inventor not known" );
				::SetWindowText( ::GetDlgItem( hWndDlg, IDC_NAME_OF_GAME_STATIC ), selectedVariant->name );
				::SetWindowText( ::GetDlgItem( hWndDlg, IDC_INVENTOR_STATIC ), buffer );
			}
		}
		
		return TRUE;

	  case WM_COMMAND:
		switch(wParam)
		{
		  case IDOK:
			whiteComp = ::SendDlgItemMessage( hSubDialog, IDC_COMPUTER_PLAYER0_CHECK, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED;
			blackComp = ::SendDlgItemMessage( hSubDialog, IDC_COMPUTER_PLAYER1_CHECK, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED;
			useOpeningBook = ::SendDlgItemMessage( hSubDialog, IDC_OPENING_BOOK_CHECK, BM_GETCHECK, 0, (LPARAM) 0 ) == BST_CHECKED;
			::SendDlgItemMessage( hSubDialog, IDC_THINK_TIME_EDIT, WM_GETTEXT, (WPARAM) 18, (LPARAM) buffer );
			maxThinkTime = atoi( buffer );

			::EndDialog( hWndDlg, IDOK );
			return TRUE;
		}
		break;
	}

	return FALSE;
}

void GenericStartGameFunction
	( GameInformation *game )
{
	if( !justLoaded && !arg )
		int rtn = (int) ::DialogBox( theInstance, MAKEINTRESOURCE(game->dialogResourceID), NULL, 
			reinterpret_cast<DLGPROC>(Generic_SelectDlgProc) );

	if( game->rank_count == 10 && game->file_count == 10 )
		theBoard = new DecimalBoard();
	else
		theBoard = new Board( game->rank_count, game->file_count );

	char *player0Name = game->player0Name;
	char *player1Name = game->player1Name;
	LookupStringParameter( "player1", player0Name );
	LookupStringParameter( "player2", player1Name );
	CreatePlayers( player0Name, player1Name, whiteComp, blackComp );

	strcpy( gameSelection, game->name );
}
