
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__COURIER_CHESS_TYPES_H
#define FILE__COURIER_CHESS_TYPES_H


#include "Historic_Data.h"


class CourierRook:
	public PieceType128
{
  public:
	//	construction
	CourierRook():
		PieceType128("Rook", "Rook", "R", 8, 12)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType128::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WRook.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BRook.bmp";
		bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WRook.bmp";
		bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BRook.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WRook.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BRook.bmp";
		bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WRook.bmp";
		bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BRook.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WRook.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BRook.bmp";
		AddMovementCapability( MovementCapability(  1,  0, 0 ) );
		AddMovementCapability( MovementCapability( -1,  0, 0 ) );
		AddMovementCapability( MovementCapability(  0,  1, 0 ) );
		AddMovementCapability( MovementCapability(  0, -1, 0 ) );
		SetSquareBonuses( 0, rookSquareBonuses_12x8 );
		SetSquareBonuses( 1, rookSquareBonuses_12x8 );
		SetSquareBonuses( 2, rookSquareBonuses_12x8 );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -8 );
		SetTropism( 7, -8 );
		SetTropism( 7, -8 );
		SetTropism( 8, -8 );
		SetTropism( 9, -8 );
		SetTropism( 10, -8 );
		SetTropism( 11, -8 );
		baseValue = 5500;
		perCaptureValueBonus = 50;
		perCaptureBonusThreshold = 10;
	}

	static CourierRook courierRook;
};

class CourierElephant:
	public PieceType128
{
  public:
	//	construction
	CourierElephant():
		PieceType128("Elephant", "Elephant", "E", 8, 12)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType128::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WElephant.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BElephant.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WElephant.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BElephant.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WElephant.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BElephant.bmp";
		AddMovementCapability( MovementCapability(  2,  2, 1 ) );
		AddMovementCapability( MovementCapability( -2,  2, 1 ) );
		AddMovementCapability( MovementCapability(  2, -2, 1 ) );
		AddMovementCapability( MovementCapability( -2, -2, 1 ) );
		SetSquareBonuses( 0, bishopSquareBonuses_12x8 );
		SetSquareBonuses( 1, bishopSquareBonuses_12x8 );
		SetSquareBonuses( 2, bishopSquareBonuses_12x8 );
		optimization = SimpleSingleStep;
		baseValue = 1000;
	}

	static CourierElephant courierElephant;
};

class CourierKnight:
	public PieceType128
{
  public:
	//	construction
	CourierKnight():
		PieceType128("Knight", "Knight", "N", 8, 12)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType128::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnight.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnight.bmp";
		bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKnight.bmp";
		bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKnight.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnight.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnight.bmp";
		bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnight.bmp";
		bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnight.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WKnight.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BKnight.bmp";
		AddMovementCapability( MovementCapability( -1,  2, 1 ) );
		AddMovementCapability( MovementCapability(  1,  2, 1 ) );
		AddMovementCapability( MovementCapability( -2,  1, 1 ) );
		AddMovementCapability( MovementCapability(  2,  1, 1 ) );
		AddMovementCapability( MovementCapability( -1, -2, 1 ) );
		AddMovementCapability( MovementCapability(  1, -2, 1 ) );
		AddMovementCapability( MovementCapability( -2, -1, 1 ) );
		AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		SetSquareBonuses( 0, knightSquareBonuses_12x8 );
		SetSquareBonuses( 1, knightSquareBonuses_12x8 );
		SetSquareBonuses( 2, knightSquareBonuses_12x8 );
		optimization = SimpleSingleStep;
		baseValue = 4000;
	}

	static CourierKnight courierKnight;
};

class CourierFerz:
	public PieceType128
{
  public:
	//	construction
	CourierFerz():
		PieceType128("Ferz", "General", "G", 8, 12)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType128::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WFerz.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BFerz.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WFers.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BFers.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCounsellor.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCounsellor.bmp";
		AddMovementCapability( MovementCapability(  1,  1, 1 ) );
		AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		AddMovementCapability( MovementCapability(  1, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		SetSquareBonuses( 0, queenSquareBonuses_12x8 );
		SetSquareBonuses( 1, queenSquareBonuses_12x8 );
		SetSquareBonuses( 2, queenSquareBonuses_12x8 );
		optimization = SimpleSingleStep;
		baseValue = 1850;
	}

	static CourierFerz courierFerz;
};

class CourierPawn:
	public PieceType128
{
  public:
	//	construction
	CourierPawn():
		PieceType128("Pawn", "Pawn", "P", 8, 12)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType128::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
		bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
		bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
		bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WPawn.bmp";
		bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BPawn.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
		AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
		AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
		AddMovementCapability( MovementCapability(  0, 1, 1, MoveOnly ) );
		SetSquareBonuses( 0, openingPawnSquareBonuses_12x8 );
		SetSquareBonuses( 1, pawnSquareBonuses_12x8 );
		SetSquareBonuses( 2, pawnSquareBonuses_12x8 );
		promotion.SetPromotionCapability( PromoteToSpecificType );
		promotion.SetTypeToPromoteTo( CourierFerz::courierFerz );
		baseValue = 1000;
		isPawn = true;
	}

	static CourierPawn courierPawn;
};

class CourierKing:
	public PieceType128
{
  public:
	//	construction
	CourierKing():
		PieceType128("King", "King", "K", 8, 12)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType128::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKing.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKing.bmp";
		bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKing.bmp";
		bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKing.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKing.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKing.bmp";
		bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKing.bmp";
		bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKing.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WKing.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BKing.bmp";
		AddMovementCapability( MovementCapability(  0,  1, 1 ) );
		AddMovementCapability( MovementCapability(  1,  0, 1 ) );
		AddMovementCapability( MovementCapability(  0, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1,  0, 1 ) );
		AddMovementCapability( MovementCapability(  1,  1, 1 ) );
		AddMovementCapability( MovementCapability(  1, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		optimization = SimpleSingleStep;
		isRoyal = true;
		baseValue = 0;
	}

	static CourierKing courierKing;
};

class CourierGeneral:
	public PieceType128
{
  public:
	//	construction
	CourierGeneral():
		PieceType128("General", "Man", "M", 8, 12)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType128::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WDuke.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BDuke.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WCenturion.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BCenturion.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCommoner.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCommoner.bmp";
		AddMovementCapability( MovementCapability(  0,  1, 1 ) );
		AddMovementCapability( MovementCapability(  1,  0, 1 ) );
		AddMovementCapability( MovementCapability(  0, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1,  0, 1 ) );
		AddMovementCapability( MovementCapability(  1,  1, 1 ) );
		AddMovementCapability( MovementCapability(  1, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		SetSquareBonuses( 0, queenSquareBonuses_12x8 );
		SetSquareBonuses( 1, queenSquareBonuses_12x8 );
		SetSquareBonuses( 2, queenSquareBonuses_12x8 );
		optimization = SimpleSingleStep;
		baseValue = 4000;
	}

	static CourierGeneral courierGeneral;
};

class CourierBishop:
	public PieceType128
{
  public:
	//	construction
	CourierBishop():
		PieceType128("Bishop", "Courier", "C", 8, 12)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType128::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WBishop.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BBishop.bmp";
		bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WBishop.bmp";
		bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BBishop.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WBishop.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BBishop.bmp";
		bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WBishop.bmp";
		bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BBishop.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCourier.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCourier.bmp";
		AddMovementCapability( MovementCapability(  1,  1, 0 ) );
		AddMovementCapability( MovementCapability( -1,  1, 0 ) );
		AddMovementCapability( MovementCapability(  1, -1, 0 ) );
		AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		SetSquareBonuses( 0, bishopSquareBonuses_12x8 );
		SetSquareBonuses( 1, bishopSquareBonuses_12x8 );
		SetSquareBonuses( 2, bishopSquareBonuses_12x8 );
		baseValue = 3000;
		perCaptureValueBonus = 15;
		perCaptureBonusThreshold = 10;
	}

	static CourierBishop courierBishop;
};

class CourierWazir:
	public PieceType128
{
  public:
	//	construction
	CourierWazir():
		PieceType128("Wazir", "Schleich", "S", 8, 12)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WWazir.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BWazir.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WWazir.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BWazir.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WWazir.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BWazir.bmp";
		AddMovementCapability( MovementCapability(  0,  1, 1 ) );
		AddMovementCapability( MovementCapability(  1,  0, 1 ) );
		AddMovementCapability( MovementCapability(  0, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1,  0, 1 ) );
		SetSquareBonuses( 0, queenSquareBonuses_12x8 );
		SetSquareBonuses( 1, queenSquareBonuses_12x8 );
		SetSquareBonuses( 2, queenSquareBonuses_12x8 );
		optimization = SimpleSingleStep;
		baseValue = 1700;
	}

	static CourierWazir courierWazir;
};

class CourierQueen:
	public PieceType128
{
  public:
	//	construction
	CourierQueen():
		PieceType128("Queen", "Queen", "Q", 8, 12)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType128::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WQueen.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BQueen.bmp";
		bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WQueen.bmp";
		bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BQueen.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WQueen.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BQueen.bmp";
		bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WQueen.bmp";
		bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BQueen.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WQueen.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BQueen.bmp";
		AddMovementCapability( MovementCapability(  1,  0, 0 ) );
		AddMovementCapability( MovementCapability( -1,  0, 0 ) );
		AddMovementCapability( MovementCapability(  0,  1, 0 ) );
		AddMovementCapability( MovementCapability(  0, -1, 0 ) );
		AddMovementCapability( MovementCapability(  1,  1, 0 ) );
		AddMovementCapability( MovementCapability( -1,  1, 0 ) );
		AddMovementCapability( MovementCapability(  1, -1, 0 ) );
		AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
		baseValue = 9500;
		perCaptureValueBonus = 55;
		perCaptureBonusThreshold = 18;
	}

	static CourierQueen courierQueen;
};

class CourierDecurion:
	public PieceType128
{
  public:
	//	construction
	CourierDecurion():
		PieceType128("Decurion", "Decurion", "D", 8, 12)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType128::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WButterfly.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BButterfly.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WLion.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BLion.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCommoner.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCommoner.bmp";
		AddMovementCapability( MovementCapability(  2,  0, 1 ) );
		AddMovementCapability( MovementCapability( -2,  0, 1 ) );
		AddMovementCapability( MovementCapability(  0,  2, 1 ) );
		AddMovementCapability( MovementCapability(  0, -2, 1 ) );
		AddMovementCapability( MovementCapability(  2,  2, 1 ) );
		AddMovementCapability( MovementCapability( -2,  2, 1 ) );
		AddMovementCapability( MovementCapability(  2, -2, 1 ) );
		AddMovementCapability( MovementCapability( -2, -2, 1 ) );
		AddMovementCapability( MovementCapability( -1,  2, 1 ) );
		AddMovementCapability( MovementCapability(  1,  2, 1 ) );
		AddMovementCapability( MovementCapability( -2,  1, 1 ) );
		AddMovementCapability( MovementCapability(  2,  1, 1 ) );
		AddMovementCapability( MovementCapability( -1, -2, 1 ) );
		AddMovementCapability( MovementCapability(  1, -2, 1 ) );
		AddMovementCapability( MovementCapability( -2, -1, 1 ) );
		AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		baseValue = 6500;
	}

	static CourierDecurion courierDecurion;
};


#endif
