
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__HISTORIC_CHESS_TYPES_H
#define FILE__HISTORIC_CHESS_TYPES_H


class HistoricRook:
	public PieceType64
{
  public:
	//	construction
	HistoricRook():
		PieceType64("Historic Rook", "Rook", "R", 8, 8)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType64::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WRook.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BRook.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WRook.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BRook.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WRook.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BRook.bmp";
		AddMovementCapability( MovementCapability(  1,  0, 0 ) );
		AddMovementCapability( MovementCapability( -1,  0, 0 ) );
		AddMovementCapability( MovementCapability(  0,  1, 0 ) );
		AddMovementCapability( MovementCapability(  0, -1, 0 ) );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -8 );
		SetTropism( 7, -8 );
		SetTropism( 7, -8 );
		SetTropism( 8, -8 );
		SetTropism( 9, -8 );
		SetTropism( 10, -8 );
		SetTropism( 11, -8 );
		baseValue = 5500;
		perCaptureValueBonus = 50;
		perCaptureBonusThreshold = 10;
	}

	static HistoricRook historicRook;
};

class HistoricKnight:
	public PieceType64
{
  public:
	//	construction
	HistoricKnight():
		PieceType64("Historic Knight", "Knight", "N", 8, 8)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType64::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnight.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnight.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnight.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnight.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WKnight.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BKnight.bmp";
		AddMovementCapability( MovementCapability( -1,  2, 1 ) );
		AddMovementCapability( MovementCapability(  1,  2, 1 ) );
		AddMovementCapability( MovementCapability( -2,  1, 1 ) );
		AddMovementCapability( MovementCapability(  2,  1, 1 ) );
		AddMovementCapability( MovementCapability( -1, -2, 1 ) );
		AddMovementCapability( MovementCapability(  1, -2, 1 ) );
		AddMovementCapability( MovementCapability( -2, -1, 1 ) );
		AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		optimization = SimpleSingleStep;
		baseValue = 4000;
	}

	static HistoricKnight historicKnight;
};

class HistoricPawn:
	public PieceType64
{
  public:
	//	construction
	HistoricPawn():
		PieceType64("Historic Pawn", "Pawn", "P", 8, 8)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType64::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WPawn.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BPawn.bmp";
		AddMovementCapability( MovementCapability(  1, 1, 1, CaptureOnly ) );
		AddMovementCapability( MovementCapability( -1, 1, 1, CaptureOnly ) );
		AddMovementCapability( MovementCapability(  0, 1, 1, MoveOnly ) );
		promotion.SetPromotionCapability( PromoteToVariableTypes );
		baseValue = 1000;
		isPawn = true;
	}

	static HistoricPawn historicPawn;
};

class HistoricKing:
	public PieceType64
{
  public:
	//	construction
	HistoricKing():
		PieceType64("Historic King", "King", "K", 8, 8)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType64::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKing.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKing.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKing.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKing.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WKing.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BKing.bmp";
		AddMovementCapability( MovementCapability(  0,  1, 1 ) );
		AddMovementCapability( MovementCapability(  1,  0, 1 ) );
		AddMovementCapability( MovementCapability(  0, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1,  0, 1 ) );
		AddMovementCapability( MovementCapability(  1,  1, 1 ) );
		AddMovementCapability( MovementCapability(  1, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		optimization = SimpleSingleStep;
		isRoyal = true;
		baseValue = 0;
	}

	static HistoricKing historicKing;
};

class HistoricCommoner:
	public PieceType64
{
  public:
	//	construction
	HistoricCommoner():
		PieceType64("Historic Commoner", "Man", "M", 8, 8)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType64::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WDuke.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BDuke.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WCenturion.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BCenturion.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCommoner.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCommoner.bmp";
		AddMovementCapability( MovementCapability(  0,  1, 1 ) );
		AddMovementCapability( MovementCapability(  1,  0, 1 ) );
		AddMovementCapability( MovementCapability(  0, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1,  0, 1 ) );
		AddMovementCapability( MovementCapability(  1,  1, 1 ) );
		AddMovementCapability( MovementCapability(  1, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		optimization = SimpleSingleStep;
		baseValue = 4000;
	}

	static HistoricCommoner historicCommoner;
};

class HistoricBishop:
	public PieceType64
{
  public:
	//	construction
	HistoricBishop():
		PieceType64("Historic Bishop", "Courier", "C", 8, 8)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType64::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WBishop.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BBishop.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WBishop.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BBishop.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCourier.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCourier.bmp";
		AddMovementCapability( MovementCapability(  1,  1, 0 ) );
		AddMovementCapability( MovementCapability( -1,  1, 0 ) );
		AddMovementCapability( MovementCapability(  1, -1, 0 ) );
		AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		baseValue = 3000;
		perCaptureValueBonus = 15;
		perCaptureBonusThreshold = 10;
	}

	static HistoricBishop historicBishop;
};

class HistoricWazir:
	public PieceType64
{
  public:
	//	construction
	HistoricWazir():
		PieceType64("Historic Wazir", "Schleich", "S", 8, 8)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType64::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WWazir.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BWazir.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WWazir.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BWazir.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WWazir.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BWazir.bmp";
		AddMovementCapability( MovementCapability(  0,  1, 1 ) );
		AddMovementCapability( MovementCapability(  1,  0, 1 ) );
		AddMovementCapability( MovementCapability(  0, -1, 1 ) );
		AddMovementCapability( MovementCapability( -1,  0, 1 ) );
		optimization = SimpleSingleStep;
		baseValue = 1700;
	}

	static HistoricWazir historicWazir;
};

class HistoricQueen:
	public PieceType64
{
  public:
	//	construction
	HistoricQueen():
		PieceType64("Historic Queen", "Queen", "Q", 8, 8)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType64::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WQueen.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BQueen.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WQueen.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BQueen.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WQueen.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BQueen.bmp";
		AddMovementCapability( MovementCapability(  1,  0, 0 ) );
		AddMovementCapability( MovementCapability( -1,  0, 0 ) );
		AddMovementCapability( MovementCapability(  0,  1, 0 ) );
		AddMovementCapability( MovementCapability(  0, -1, 0 ) );
		AddMovementCapability( MovementCapability(  1,  1, 0 ) );
		AddMovementCapability( MovementCapability( -1,  1, 0 ) );
		AddMovementCapability( MovementCapability(  1, -1, 0 ) );
		AddMovementCapability( MovementCapability( -1, -1, 0 ) );
		SetTropismType( DistanceTropism );
		SetTropism( 1, 3 );
		SetTropism( 2, 3 );
		SetTropism( 3, 2 );
		SetTropism( 4, 1 );
		baseValue = 9500;
		perCaptureValueBonus = 55;
		perCaptureBonusThreshold = 18;
	}

	static HistoricQueen historicQueen;
};

class HistoricDecurion:
	public PieceType64
{
  public:
	//	construction
	HistoricDecurion():
		PieceType64("Historic Decurion", "Decurion", "D", 8, 8)
	{
	}

	virtual void Initialize()
	{
		//	call base class's Initialize function
		PieceType64::Initialize();

		//	initialize all properties to defaults
		bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WButterfly.bmp";
		bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BButterfly.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WLion.bmp";
		bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BLion.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][0] = "images\\old_world\\WCommoner.bmp";
		bitmapFileNames[PIECE_SET_OLD_WORLD][1] = "images\\old_world\\BCommoner.bmp";
		AddMovementCapability( MovementCapability(  2,  0, 1 ) );
		AddMovementCapability( MovementCapability( -2,  0, 1 ) );
		AddMovementCapability( MovementCapability(  0,  2, 1 ) );
		AddMovementCapability( MovementCapability(  0, -2, 1 ) );
		AddMovementCapability( MovementCapability(  2,  2, 1 ) );
		AddMovementCapability( MovementCapability( -2,  2, 1 ) );
		AddMovementCapability( MovementCapability(  2, -2, 1 ) );
		AddMovementCapability( MovementCapability( -2, -2, 1 ) );
		AddMovementCapability( MovementCapability( -1,  2, 1 ) );
		AddMovementCapability( MovementCapability(  1,  2, 1 ) );
		AddMovementCapability( MovementCapability( -2,  1, 1 ) );
		AddMovementCapability( MovementCapability(  2,  1, 1 ) );
		AddMovementCapability( MovementCapability( -1, -2, 1 ) );
		AddMovementCapability( MovementCapability(  1, -2, 1 ) );
		AddMovementCapability( MovementCapability( -2, -1, 1 ) );
		AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		baseValue = 6500;
	}

	static HistoricDecurion historicDecurion;
};


#endif
