
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "Historic_Data.h"


int openingPawnSquareBonuses_12x8[] = 
{   
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   20,  20,  20,  20,   0, -20, -20,   0,  20,  20,  20,  20, 
  -40, -40,  30,  30,  30,  60,  60,  30,  30,  30, -40, -40, 
  -40, -40,  40,  40,  40, 100, 100,  40,  40,  40, -40, -40, 
  -40, -40,  60,  60,  60, 160, 160,  60,  60,  60, -40, -40, 
  -40, -40,  60,  60,  60, 160, 160,  60,  60,  60, -40, -40, 
  -40, -40,  60,  60,  60, 160, 160,  60,  60,  60, -40, -40, 
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

int pawnSquareBonuses_12x8[] = 
{   
	0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
   20,  20,  20,  20, -20, -40, -40, -20,  20,  20,  20,  20, 
   20,  20,  30,  30,  20,  30,  30,  20,  30,  30,  20,  20, 
   30,  30,  40,  40, 140, 200, 200, 140,  40,  40,  30,  30, 
   50,  60, 120, 140, 160, 220, 220, 160, 140, 120,  60,  50, 
   80,  90, 140, 140, 200, 240, 240, 200, 140, 140,  90,  80, 
  100, 100, 160, 160, 240, 260, 260, 240, 160, 160, 100, 100, 
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

int bishopSquareBonuses_12x8[] = 
{
   -150,-150  -75, -75, -75, -75, -75, -75, -75, -75,-150,-150, 
   -150, -80, -60, -20,   0,   0,   0,   0, -20, -60, -80,-150, 
    -40, -20,  20,  20,  20,  20,  20,  20,  20,  20, -20, -40, 
    -40,  20,  40,  40,  40,  40,  40,  40,  40,  40,  20, -40, 
    -40,  20,  60,  80,  80,  80,  80,  80,  80,  60,  20, -40, 
    -40,  20,  60,  80,  80,  80,  80,  80,  80,  60,  20, -40, 
   -150, -80,  40,  40,  40,  40,  40,  40,  40,  40, -80,-150, 
   -150,-150,   0,   0,   0,   0,   0,   0,   0,   0,-150,-150
};

int knightSquareBonuses_12x8[] = 
{
  -125, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25,-125, 
   -50, -20,  10,  30,  30,  30,  30,  30,  30,  10, -20, -50, 
   -50,  10,  60,  60,  60,  60,  60,  60,  60,  60,  10, -50, 
   -50,  10,  60, 110, 130, 150, 150, 130, 110,  60,  10, -50, 
   -50,  10,  60, 110, 130, 150, 150, 130, 110,  60,  10, -50, 
   -50,  10,  60,  90,  90, 110, 110,  90,  90,  60,  10, -50,
   -50, -10,   0,  20,  40,  60,  60,  40,  20,   0, -10, -50,
  -125, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50,-125
};

int	queenSquareBonuses_12x8[] = 
{
   0,  0,  40,  50,  60,  80,  80,  60,  50,  40,  0,  0,
   0,  0,  40,  50,  60,  80,  80,  60,  50,  40,  0,  0,
   0,  0,  40,  50,  60,  80,  80,  60,  50,  40,  0,  0,
   0,  0,  60,  70,  70,  80,  80,  70,  70,  60,  0,  0,
   0,  0,  60,  70,  75,  90,  90,  75,  70,  60,  0,  0,
   0,  0,  60,  70,  75, 100, 100,  75,  70,  60,  0,  0,
  40, 40,  80, 100, 120, 140, 140, 120, 100,  80, 40, 40,
  20, 20,  50,  70,  80, 100, 100,  80,  70,  50, 20, 20
};

int	openingQueenSquareBonuses_12x8[] = 
{
   0,  0,  40,  50,  60, 280,  80,  60,  50,  40,  0,  0,
   0,  0,  40,  50,  60,  80,  80,  60,  50,  40,  0,  0,
   0,  0,  40,  50,  60,  80,  80,  60,  50,  40,  0,  0,
   0,  0,  40,  50,  65,  90,  90,  65,  50,  40,  0,  0,
   0,  0,  40,  50,  65,  90,  90,  65,  50,  40,  0,  0,
   0,  0,  40,  50,  60,  80,  80,  60,  50,  40,  0,  0,
   0,  0,  40,  50,  60,  80,  80,  60,  50,  40,  0,  0,
   0,  0,  40,  50,  60,  80,  80,  60,  50,  40,  0,  0
};

int rookSquareBonuses_12x8[] = 
{
   0,  0,  40,  50,  60,  80,  80,  60,  50,  40,  0,  0,
   0,  0,  40,  50,  60,  80,  80,  60,  50,  40,  0,  0,
   0,  0,  40,  50,  60,  80,  80,  60,  50,  40,  0,  0,
   0,  0,  40,  50,  60,  80,  80,  60,  50,  40,  0,  0,
   0,  0,  40,  50,  60,  90,  90,  60,  50,  40,  0,  0,
   0,  0,  40,  60,  75, 100, 100,  75,  60,  40,  0,  0,
  40, 40,  80, 100, 120, 140, 140, 120, 100,  80, 40, 40,
  20, 20,  50,  70,  80, 100, 100,  80,  70,  50, 20, 20
};

int kingSquareBonuses_12x8[] =
{
   240, 240, 240, 160, 160, 160, 160, 160, 160, 240, 320, 320,
   240, 200, 160, 120, 120, 120, 120, 120, 120, 160, 200, 240,
   160, 120,  80,  40,  40,  40,  40,  40,  40,  80, 120, 160,
   120,  80,  40,   0,   0,   0,   0,   0,   0,  40,  80, 120,
    60,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  60,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

int endgameKingSquareBonuses_12x8[] =
{
    0,  60, 120, 180, 180, 180, 180, 180, 180, 120,  60,   0,
   60, 120, 180, 240, 240, 240, 240, 240, 240, 180, 120,  60,
  120, 180, 240, 320, 320, 320, 320, 320, 320, 240, 180, 120,
  180, 240, 320, 480, 480, 480, 480, 480, 480, 320, 240, 180,
  180, 240, 320, 480, 480, 480, 480, 480, 480, 320, 240, 180,
  120, 180, 240, 320, 320, 320, 320, 320, 320, 240, 180, 120,
   60, 120, 180, 240, 240, 240, 240, 240, 240, 180, 120,  60,
    0,  60, 120, 180, 180, 180, 180, 180, 180, 120,  60,   0
};


//	values for posted pieces...
//	IMPORTANT: don't put non-zero values
//	on the left-most or right-most files!
//	the outpost code checks for pawns to
//	the left and right, and it doesn't 
//	check to make sure that's not off the
//	edge of the board!
//	you wouldn't want an outpost on the
//	rim anyway; it's not worth a bonus
int outpost_12x8[] = 
{
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
    0,   0,   0,   0,   2,   2,   2,   2,   0,   0,   0,   0,
    0,   0,   5,   8,   8,   8,   8,   8,   8,   5,   0,   0,
    0,   0,  12,  16,  16,  16,  16,  16,  16,  12,   0,   0,
    0,   0,  12,  18,  18,  18,  18,  18,  18,  12,   0,   0,
    0,   0,   6,  12,  12,  12,  12,  12,  12,   6,   0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};
