
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__ULTIMA_GAME_H
#define FILE__ULTIMA_GAME_H


#include "../../Board.h"
#include "../../Player.h"
#include "../../PieceType.h"
#include "../../Game.h"


//	************************
//	**                    **
//	**     UltimaGame     **
//	**                    **
//	************************


class UltimaGame:
	public Game
{
  protected:
	//	data members
	Piece *withdrawers[2];
	Piece *immobilizers[2];
	Piece *coordinators[2];
	Piece *longLeapers[2][SET_SIZE];
	Piece *chameleons[2][SET_SIZE];
	Piece *pawns[2][SET_SIZE];


	//	helper functions
	bool IsImmobilized( Piece *piece );


  public:
	// *** INITIALIZATION *** //
	UltimaGame( Board &board, Player &whitePlayer, Player &blackPlayer );

	virtual void AddPlayerPieceTypes( char *gameName );

	virtual void ChangeRulesByVariant( char *gameName, char *&array, char *&book );


	// *** OVERRIDES *** //
	virtual PieceType **GetPieceTypesRequired
		( int &nPieceTypes );

	virtual bool MoveBeingMade
		( MoveInfo &moveInfo,
		  GameRec &gameRecord );

	virtual void AddSpecialMoves
		( int currentPlayer, 
		  MovementList &stack,
		  GameRec &gameRecord,
		  bool quiescentSearch );

	virtual int TranslateMove
		( MovementList &stack,
		  char *notation );

	virtual Phase &AdjustEvaluation
		( int &eval,
		  PawnHash *pPawnHash );

	virtual Piece *AddPiece
		( PieceType &pieceType,
		  int nPlayer,
		  int nRank,
		  int nFile );

	virtual void DeletePiece
		( Piece *piece );

	virtual void AboutToGenerateMoves
		( int currentPlayer,
		  int currentDepth );

	virtual void AboutToStartThinking
		( int currentPlayer );

	virtual bool IsInCheck( Piece *king );
};


#endif
