
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2007 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__ULTIMA_TYPES_H
#define FILE__ULTIMA_TYPES_H


#include "../../PieceType.h"


class Immobilizer:
	public PieceType64
{
  public:
	//	construction
	Immobilizer():
		PieceType64("Immobilizer", "Immobilizer", "I", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WRookInv.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BRookInv.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WRookInv.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BRookInv.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WImmobilizer.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BImmobilizer.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WImmobilizer.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BImmobilizer.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][0] = "images\\ultima\\WImmobilizer.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][1] = "images\\ultima\\BImmobilizer.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WDownRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BDownRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability( -1,  0, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability(  0,  1, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability(  0, -1, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability(  1,  1, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability( -1,  1, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability(  1, -1, 0, MoveOnly ) );
			AddMovementCapability( MovementCapability( -1, -1, 0, MoveOnly ) );
		}

		baseValue = 8200;
		SetSquareBonuses( 0, genericSmallCenterBonuses );
		SetSquareBonuses( 1, genericSmallCenterBonuses );
		SetSquareBonuses( 2, genericSmallCenterBonuses );
		SetTropismType( DistanceTropism );
		SetTropism( 1, 12 );
		SetTropism( 2, 4 );
		SetTropism( 3, 2 );
	}

	static Immobilizer immobilizer;
};

class Withdrawer:
	public PieceType64
{
  public:
	//	construction
	Withdrawer():
		PieceType64("Withdrawer", "Withdrawer", "W", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BQueen.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][0] = "images\\ultima\\WWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][1] = "images\\ultima\\BWithdrawer.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WQueen.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BQueen.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability( -1,  0, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability(  0,  1, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability(  0, -1, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability(  1,  1, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability( -1,  1, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability(  1, -1, 0, MoveOnly, 0, 99, true, false ) );
			AddMovementCapability( MovementCapability( -1, -1, 0, MoveOnly, 0, 99, true, false ) );
		}

		baseValue = 3100;
		SetSquareBonuses( 0, genericSmallCenterBonuses );
		SetSquareBonuses( 1, genericSmallCenterBonuses );
		SetSquareBonuses( 2, genericSmallCenterBonuses );
		SetTropismType( DistanceTropism );
		SetTropism( 1, 4 );
		SetTropism( 2, 1 );
	}

	static Withdrawer withdrawer;
};

class LongLeaper:
	public PieceType64
{
  public:
	//	construction
	LongLeaper():
		PieceType64("Long Leaper", "Long Leaper", "L", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WLongLeaper.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BLongLeaper.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WLongLeaper.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BLongLeaper.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][0] = "images\\ultima\\WLongLeaper.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][1] = "images\\ultima\\BLongLeaper.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKnight.bmp";
		}

		baseValue = 5300;
		SetSquareBonuses( 0, longLeaperSquareBonuses );
		SetSquareBonuses( 1, longLeaperSquareBonuses );
		SetSquareBonuses( 2, longLeaperSquareBonuses );
		SetTropismType( HVDistanceTropism );
		SetTropism( 0, 5 );
		SetTropism( 1, 3 );
		SetTropism( 2, 1 );
		SetTropism( 3, 1 );
	}

	static LongLeaper longLeaper;
};

class Chameleon:
	public PieceType64
{
  public:
	//	construction
	Chameleon():
		PieceType64("Chameleon", "Chameleon", "X", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BBishop.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WChameleon.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BChameleon.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WChameleon.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BChameleon.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][0] = "images\\ultima\\WChameleon.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][1] = "images\\ultima\\BChameleon.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WBishop.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BBishop.bmp";
		}

		baseValue = 4300;
		SetSquareBonuses( 0, chameleonSquareBonuses );
		SetSquareBonuses( 1, chameleonSquareBonuses );
		SetSquareBonuses( 2, chameleonSquareBonuses );
	}

	static Chameleon chameleon;
};

class Coordinator:
	public PieceType64
{
  public:
	//	construction
	Coordinator():
		PieceType64("Coordinator", "Coordinator", "C", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BRook.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WCoordinator.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BCoordinator.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WCoordinator.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BCoordinator.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][0] = "images\\ultima\\WCoordinator.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][1] = "images\\ultima\\BCoordinator.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WRook.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BRook.bmp";
		}

		baseValue = 2900;
		SetSquareBonuses( 0, rookSquareBonuses );
		SetSquareBonuses( 1, rookSquareBonuses );
		SetSquareBonuses( 2, rookSquareBonuses );
		SetTropismType( HVDistanceTropism );
		SetTropism( 0, 4 );
		SetTropism( 1, 2 );
		SetTropism( 2, 1 );
		SetTropism( 3, 1 );
	}

	static Coordinator coordinator;
};

class UltimaPawn:
	public PieceType64
{
  public:
	//	construction
	UltimaPawn():
		PieceType64("Ultima Pawn", "Pawn", "P", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WPincerPawn.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BPincerPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WUltimaPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BUltimaPawn.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][0] = "images\\ultima\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][1] = "images\\ultima\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BPawn.bmp";
		}

		baseValue = 1000;
		SetSquareBonuses( 0, openingUltimaPawnBonuses );
		SetSquareBonuses( 1, genericSmallCenterBonuses );
		SetSquareBonuses( 2, genericSmallCenterBonuses );
	}

	static UltimaPawn ultimaPawn;
};

class UltimaKing:
	public PieceType64
{
  public:
	//	construction
	UltimaKing():
		PieceType64("Ultima King", "King", "K", 8, 8)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType64::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKing.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKing.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][0] = "images\\standard\\WKing.bmp";
			bitmapFileNames[PIECE_SET_ALTERNATE][1] = "images\\standard\\BKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKing.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][0] = "images\\ultima\\WKing.bmp";
			bitmapFileNames[PIECE_SET_ULTIMA][1] = "images\\ultima\\BKing.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][0] = "images\\motif\\WKing.bmp";
			bitmapFileNames[PIECE_SET_MOTIF][1] = "images\\motif\\BKing.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
		}

		baseValue = 30000;
		SetSquareBonuses( 0, ultimaKingSquareBonuses );
		SetSquareBonuses( 1, ultimaKingSquareBonuses);
		SetSquareBonuses( 2, ultimaKingSquareBonuses );
		optimization = SimpleSingleStep;
		isRoyal = true;
	}

	static UltimaKing ultimaKing;
};


#endif
