
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2010 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#include "StdAfx.h"
#include "XiangQi_Data.h"


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
#define new SAFE_NEW
#endif


// *** PIECE SQUARE TABLES for the Xiang Qi Board (9 x 10) ***
//
//	NOTE: all values are in milli-pawns


int zeroes_9x10[] = 
{
	0,  0,  0,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  0,  0,  0,
	0,  0,  0,  0,  0,  0,  0,  0,  0
};

int rookSquareBonuses_9x10[] = 
{
    0,   0,  30,  60,  70,  60,  30,   0,   0,
    0,   0,  30,  60,  70,  60,  30,   0,   0,
    0,   0,  30,  60,  70,  60,  30,   0,   0,
    0,   0,  30,  60,  70,  60,  30,   0,   0,
    0,   0,  30,  60,  70,  60,  30,   0,   0,
    0,   0,  30,  60,  70,  60,  30,   0,   0,
    0,   0,  30,  60,  70,  60,  30,   0,   0,
    0,   0,  30,  60,  70,  60,  30,   0,   0,
    0,   0,  30,  60,  70,  60,  30,   0,   0,
    0,   0,  30,  60,  70,  60,  30,   0,   0
};

int knightSquareBonuses_9x10[] = 
{
	-82, -74, -65, -64, -63, -64, -65, -74, -82,
	-22, -44,  13,  14,  25,  14,  13, -44, -22,
	  9,  34,  61,  62,  72,  62,  61,  34,   9,
	 11,  36,  63,  64,  74,  64,  63,  36,  11,
	 13,  48,  75,  76,  86,  76,  75,  48,  13,
	 15,  50,  77,  78,  88,  78,  77,  50,  15,
	 17,  43,  69, 120, 151, 120,  69,  43,  17,
	 19,  45, 102, 173, 183, 173, 102,  45,  19,
	  9,  19, 146, 157, 197, 157, 146,  19,   9,
	 -2,   7,  48, 119, 120, 119,  48,   7,  -2
};


int pawnSquareBonuses_9x10[] = 
{
    0,    0,    0,    0,    0,    0,    0,    0,    0, 
   20,   20,   20,   20,  -40,   20,   20,   20,   20, 
   20,   20,   30,   30,   20,   30,   30,   20,   20, 
   20,   20,   30,   50,  100,   50,   30,   20,   20, 
   30,   30,   50,   60,  200,   60,   50,   30,   30, 
 1040, 1040, 1060, 1120, 1180, 1120, 1060, 1040, 1040, 
 1040, 1040, 1060, 1200, 1250, 1200, 1060, 1040, 1040, 
 1040, 1040, 1060, 1300, 1500, 1300, 1060, 1040, 1040, 
 1040, 1040, 1060, 1400, 1400, 1400, 1060, 1040, 1040 
};

int kingSquareBonuses_9x10[] = 
{
	0,   0,   0,-200, 100,-200,   0,   0,   0,
	0,   0,   0,-800,-800,-800,   0,   0,   0,
	0,   0,   0,-900,-900,-900,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0
};

int advisorSquareBonuses_9x10[] = 
{
	0,   0,   0,  50,   0,  50,   0,   0,   0,
	0,   0,   0,   0, 100,   0,   0,   0,   0,
	0,   0,   0, -50,   0, -50,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0,
	0,   0,   0,   0,   0,   0,   0,   0,   0
};
