
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2010 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the License,
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__XIANGQI_TYPES_H
#define FILE__XIANGQI_TYPES_H


#include "../../PieceType.h"
#include "../../Personality.h"
#include "XiangQi_Data.h"


class XiangQiRook:
	public PieceType96
{
  public:
	//	construction
	XiangQiRook():
		PieceType96("Rook", "Rook", "R", 10, 9)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WRook.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WRook.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WRook.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BRook.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WRook.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BRook.bmp";
			AddMovementCapability( MovementCapability(  1,  0, 0 ) );
			AddMovementCapability( MovementCapability( -1,  0, 0 ) );
			AddMovementCapability( MovementCapability(  0,  1, 0 ) );
			AddMovementCapability( MovementCapability(  0, -1, 0 ) );
		}

		if( personality >= PERSONALITY_C )
		{
			baseValue = 6000;
		}
		else
		{
			baseValue = 5500;
			perCaptureValueBonus = 75;
			perCaptureBonusThreshold = 10;
		}

		SetSquareBonuses( 0, rookSquareBonuses_9x10 );
		SetSquareBonuses( 1, rookSquareBonuses_9x10 );
		SetSquareBonuses( 2, zeroes_9x10 );
		SetMobility( StandardMobility, 0, 16 );
		SetTropismType( HVDistanceTropism );
		SetTropism( 1, -1 );
		SetTropism( 2, -3 );
		SetTropism( 3, -5 );
		SetTropism( 4, -6 );
		SetTropism( 5, -8 );
		SetTropism( 6, -9 );
		SetTropism( 7, -10 );
		SetTropism( 8, -10 );
		SetTropism( 9, -10 );
		optimization = SimpleSlider;
	}

	static XiangQiRook xiangQiRook;
};


class XiangQiCannon:
	public PieceType96
{
  public:
	//	construction
	XiangQiCannon():
		PieceType96("Cannon", "Cannon", "C", 10, 9)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WCannon.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BCannon.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\standard\\WCannon.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\standard\\BCannon.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WCannon.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BCannon.bmp";
		}

		SetSquareBonuses( 0, rookSquareBonuses_9x10 );
		SetSquareBonuses( 1, rookSquareBonuses_9x10 );
		SetSquareBonuses( 2, zeroes_9x10 );

		baseValue = 4600;
		perCaptureValueBonus = -40;
		perCaptureBonusThreshold = 6;
	}

	static XiangQiCannon xiangQiCannon;
};

class XiangQiKnight:
	public PieceType96
{
  public:
	//	construction
	XiangQiKnight():
		PieceType96("Knight", "Knight", "N", 10, 9)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKnight.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WKnight.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BKnight.bmp";
			AddMovementCapability( MovementCapability( -1,  2, 1 ) );
			AddMovementCapability( MovementCapability(  1,  2, 1 ) );
			AddMovementCapability( MovementCapability( -2,  1, 1 ) );
			AddMovementCapability( MovementCapability(  2,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -2, 1 ) );
			AddMovementCapability( MovementCapability(  1, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -1, 1 ) );
			AddMovementCapability( MovementCapability(  2, -1, 1 ) );
		}

		baseValue = 2350;
		SetSquareBonuses( 0, knightSquareBonuses_9x10 );
		SetSquareBonuses( 1, knightSquareBonuses_9x10 );
		SetSquareBonuses( 2, knightSquareBonuses_9x10 );

		optimization = SimpleSingleStep;
	}

	static XiangQiKnight xiangQiKnight;
};

class XiangQiElephant:
	public PieceType96
{
  public:
	//	construction
	XiangQiElephant():
		PieceType96("Elephant", "Elephant", "E", 10, 9)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BElephant.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WElephant.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BElephant.bmp";
			AddMovementCapability( MovementCapability(  2,  2, 1, Normal, 0, 35 ) );
			AddMovementCapability( MovementCapability( -2,  2, 1, Normal, 0, 35 ) );
			AddMovementCapability( MovementCapability(  2, -2, 1 ) );
			AddMovementCapability( MovementCapability( -2, -2, 1 ) );
		}

		baseValue = 1000;
		SetSquareBonuses( 0, zeroes_9x10 );
		SetSquareBonuses( 1, zeroes_9x10 );
		SetSquareBonuses( 2, zeroes_9x10 );
	}

	static XiangQiElephant xiangQiElephant;
};

class XiangQiAdvisor:
	public PieceType96
{
  public:
	//	construction
	XiangQiAdvisor():
		PieceType96("Advisor", "Advisor", "A", 10, 9)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WFerz.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BFerz.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WFers.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BFers.bmp";
			AddMovementCapability( MovementCapability(  1,  1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1, -1, 1 ) );
		}

		baseValue = 1850;
		SetSquareBonuses( 0, advisorSquareBonuses_9x10 );
		SetSquareBonuses( 1, advisorSquareBonuses_9x10 );
		SetSquareBonuses( 2, advisorSquareBonuses_9x10 );

		optimization = SimpleSingleStep;
	}

	static XiangQiAdvisor xiangQiAdvisor;
};

class XiangQiPawn:
	public PieceType96
{
  public:
	//	construction
	XiangQiPawn():
		PieceType96("Pawn", "Pawn", "P", 10, 9)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BPawn.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WPawn.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BPawn.bmp";
			AddMovementCapability( MovementCapability(  0, 1, 1 ) );
			AddMovementCapability( MovementCapability(  1, 0, 1, Normal, 45, 89 ) );
			AddMovementCapability( MovementCapability( -1, 0, 1, Normal, 45, 89 ) );
		}

		baseValue = 1000;
		SetSquareBonuses( 0, pawnSquareBonuses_9x10 );
		SetSquareBonuses( 1, pawnSquareBonuses_9x10 );
		SetSquareBonuses( 2, pawnSquareBonuses_9x10 );
	}

	static XiangQiPawn xiangQiPawn;
};

class XiangQiKing:
	public PieceType96
{
  public:
	//	construction
	XiangQiKing():
		PieceType96("King", "King", "K", 10, 9)
	{
	}

	virtual void Initialize( int personality )
	{
		bool initialized = hasBeenInitialized;

		//	call base class's Initialize function
		PieceType96::Initialize( personality );

		//	initialize all properties to defaults
		if( !initialized )
		{
			bitmapFileNames[PIECE_SET_STANDARD][0] = "images\\standard\\WKing.bmp";
			bitmapFileNames[PIECE_SET_STANDARD][1] = "images\\standard\\BKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][0] = "images\\small\\WKing.bmp";
			bitmapFileNames[PIECE_SET_SMALL][1] = "images\\small\\BKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][0] = "images\\abstract\\WKing.bmp";
			bitmapFileNames[PIECE_SET_ABSTRACT][1] = "images\\abstract\\BKing.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][0] = "images\\eurasian\\WKing.bmp";
			bitmapFileNames[PIECE_SET_EURASIAN][1] = "images\\eurasian\\BKing.bmp";
			AddMovementCapability( MovementCapability(  0,  1, 1 ) );
			AddMovementCapability( MovementCapability(  1,  0, 1 ) );
			AddMovementCapability( MovementCapability(  0, -1, 1 ) );
			AddMovementCapability( MovementCapability( -1,  0, 1 ) );
		}

		baseValue = 100000;
		SetSquareBonuses( 0, kingSquareBonuses_9x10 );
		SetSquareBonuses( 1, kingSquareBonuses_9x10 );
		SetSquareBonuses( 2, kingSquareBonuses_9x10 );
		optimization = SimpleSingleStep;
		isRoyal = true;
	}

	static XiangQiKing xiangQiKing;
};


#endif
