
/***************************************************************************

                                 ChessV

                   COPYRIGHT (C) 2005 BY GREGORY STRONG

This file is part of ChessV.  ChessV is free software; you can redistribute
it and/or modify it under the terms of the GNU General Public License as 
published by the Free Software Foundation; either version 2 of the License, 
or (at your option) any later version.

ChessV is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details; the file 'COPYING' contains the License text, but if for
some reason you need a copy, please write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/


#ifndef FILE__STDAFX_H
#define FILE__STDAFX_H


#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
// Windows Header Files:
#include <windows.h>
// C RunTime Header Files
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
//#include <tchar.h>
#include <stdio.h>
#include <commdlg.h>
#include <commctrl.h>
#include <math.h>
#include "WinUtil.h"


typedef unsigned char byte;
typedef unsigned int word32;


class ChessGame;
class Player;
class Piece;
class PieceType;
class MovementCapability;
class Board;
class Movement;
class Capture;
class Game;
class MovementList;
struct MoveInfo;


enum NodeType
{
	PV = 0,
	All = 1,
	Cut = 2
};

enum MobilityType
{
	NoMobility = 0,
	StandardMobility = 1,
	AutomaticBitboardMobility = 2
};

enum TropismType
{
	NoTropism = 0,
	DistanceTropism = 1,
	HVDistanceTropism = 2
};


//	macro to flip the current player; this will have 
//	to become far more complicated if we are ever to 
//	support games with more than two players, or games 
//	with unusual move orders, like Progressive Chess
#define FLIP(player)  (player ^ 1)


//	cardinal direction numbers; these are
//	the only pre-defined Directions
#define DIRECTION_N    0
#define DIRECTION_NE   1
#define DIRECTION_NW   2
#define DIRECTION_S    3
#define DIRECTION_SE   4
#define DIRECTION_SW   5
#define DIRECTION_E    6
#define DIRECTION_W    7


//	types of bitboards
#define BITBOARD_NONE		0
#define BITBOARD_64			1
#define BITBOARD_96			2
#define BITBOARD_128		3


//	some maximums
#define MAX_PIECE_TYPES 60
#define MAX_PIECES		500
#define MAX_PAWNS		128
#define MAX_MOVES		400
#define MAX_PLY			100
#define MAX_DEPTH		100
#define MAX_DIRECTIONS	50
#define MAX_ZONE_RANGES 40
#define MAX_GAME_LENGTH 1000
#define MAX_PHASES      8
#define MAX_SQUARES     256
#define MAX_FILES       16
#define MAX_RANKS       16
#define MAX_GAME_PARAMS	30
#define MAX_PIECE_SETS  10
#define PV_BUFF         300
#define SET_SIZE		16


//	constants identifying the piece sets
#define PIECE_SET_STANDARD				0
#define PIECE_SET_ALTERNATE				1
#define PIECE_SET_SMALL					2
#define PIECE_SET_ABSTRACT				3
#define PIECE_SET_OLD_WORLD				4
#define PIECE_SET_MOTIF					5
#define PIECE_SET_EURASIAN				6
#define PIECE_SET_ULTIMA				7
#define PIECE_SET_RUNES                 8


typedef unsigned long long bit_data;
typedef unsigned long long uint64;

//	misc
#define NULL_REDUCTION		2

#define INFINITY       1000000
#define MATE		   1000000

#define WINDOW			500

#define MATESCORE(a)	((a) > INFINITY-MAX_DEPTH  || (a) < -INFINITY+MAX_DEPTH)

#define MIN(x,y)  ((x) < (y) ? (x) : (y))
#define MAX(x,y)  ((x) > (y) ? (x) : (y))


// *** DEBUG ASSERTIONS *** //

#ifdef _DEBUG
#define ASSERT(condition)         \
	if( !(condition) )            \
	{                             \
		DebugBreak();             \
	}
#else
#define ASSERT(condition)         \
	if( !(condition) )            \
	{                             \
		::MessageBox( NULL, "assert failed", "assert failed", MB_ICONHAND | MB_OK );  \
	}
#endif


// *** DEBUG MEMORY ALLOCATION *** //
#ifdef _DEBUG
//void *operator new( size_t nSize, char *filename, int nLine );
//#define SAFE_NEW new( __FILE__, __LINE__ )
//#define new SAFE_NEW
#define SAFE_NEW new
#endif


#ifdef _DEBUG
#define NO_MANS_LAND(x)			int no_mans_land##x;
#define INIT_NO_MANS_LAND(x)	no_mans_land##x = 0xA9A9A9A9;
#define ASSERT_NO_MANS_LAND(x)	ASSERT(no_mans_land##x == 0xA9A9A9A9)
#else
#define NO_MANS_LAND(x)
#define INIT_NO_MANS_LAND(x)
#define ASSERT_NO_MANS_LAND(x)
#endif


#ifdef _DEBUG
//#define TRACE_ON 
#endif


#ifdef TRACE_ON
#define TRACE(str, arg)                                                \
{                                                                      \
	int i;                                                             \
	char buffer[120];                                                  \
	for( i = 1; i < currentDepth; i++ )                                \
		buffer[i-1] = ' ';                                             \
	strcpy( buffer + i - 1, str );                                     \
	fprintf( traceFile, buffer, arg );                                 \
	fflush( traceFile );                                               \
}
#define QTRACE(str, arg)                                               \
{                                                                      \
	if( qdepth >= 0 )                                                  \
	{                                                                  \
		int i;                                                         \
		char buffer[120];                                              \
		for( i = 1; i < currentDepth; i++ )                            \
			buffer[i-1] = ' ';                                         \
		strcpy( buffer + i - 1, str );                                 \
		fprintf( traceFile, buffer, arg );                             \
		fflush( traceFile );                                           \
	}                                                                  \
}
#define TRACE_MOVE(str, moveinfo, arg1, arg2, arg3)                    \
{                                                                      \
	int i;                                                             \
	char buffer[120];                                                  \
	for( i = 1; i < currentDepth; i++ )                                \
		buffer[i-1] = ' ';                                             \
	char moveBuffer[80];                                               \
	theGame->DescribeMove( moveinfo, NULL, moveBuffer, NULL );         \
	sprintf( buffer + i - 1, str, moveBuffer, arg1, arg2, arg3 );      \
	fprintf( traceFile, buffer );                                      \
	fflush( traceFile );                                               \
}
#define QTRACE_MOVE(str, moveinfo, arg1, arg2)                         \
{                                                                      \
	if( qdepth >= 0 )                                                  \
	{                                                                  \
		int i;                                                         \
		char buffer[120];                                              \
		for( i = 1; i < currentDepth; i++ )                            \
			buffer[i-1] = ' ';                                         \
		char moveBuffer[80];                                           \
		theGame->DescribeMove( moveinfo, NULL, moveBuffer, NULL );     \
		sprintf( buffer + i - 1, str, moveBuffer, arg1, arg2 );        \
		fprintf( traceFile, buffer );                                  \
		fflush( traceFile );                                           \
	}                                                                  \
}
#define TRACE_MOVE0(str, moveinfo)                                     \
{                                                                      \
	int i;                                                             \
	char buffer[120];                                                  \
	for( i = 1; i < currentDepth; i++ )                                \
		buffer[i-1] = ' ';                                             \
	char moveBuffer[80];                                               \
	theGame->DescribeMove( moveinfo, NULL, moveBuffer, NULL );         \
	sprintf( buffer + i - 1, str, moveBuffer );                        \
	fprintf( traceFile, buffer );                                      \
	fflush( traceFile );                                               \
}

#else
#define TRACE(str, arg)                                                ;
#define QTRACE(str, arg)                                               ;
#define TRACE_MOVE(str, moveInfo, arg1, arg2, arg3)                    ;
#define QTRACE_MOVE(str, moveInfo, arg1, arg2)                         ;
#define TRACE_MOVE0(str, moveinfo)                                     ;
#endif


extern Game *theGame;
extern Board *theBoard;
extern HWND theWindow;
extern HINSTANCE theInstance;
extern bool bInitialized;
extern Player *pPlayer0;
extern Player *pPlayer1;
extern char *arg;


#ifdef _WINBOARD_VERSION
extern int post;
extern char promoChar;
#endif


#endif
